IF EXISTS
(
    SELECT *
    FROM SYS.PROCEDURES
    WHERE NAME = 'P_CTB_CNT_DRE_PROCESSAMENTO_ALL'
)
    DROP PROCEDURE P_CTB_CNT_DRE_PROCESSAMENTO_ALL;
GO
--EXEC P_CTB_CNT_DRE_PROCESSAMENTO_ALL
CREATE PROCEDURE P_CTB_CNT_DRE_PROCESSAMENTO_ALL
AS
SET NOCOUNT ON;
SET DEADLOCK_PRIORITY HIGH;
DECLARE @MES INT
DECLARE @ANO INT
DECLARE @TP_DRE INT
DECLARE @TP_RAT_CENTRO_CUSTO INT
DECLARE @CD_CTR INT
DECLARE @CD_USU INT
DECLARE @DT_INI_PROC DATETIME
DECLARE @CD_CTR_ATUAL INT

DECLARE ProcDRE CURSOR FAST_FORWARD FOR
SELECT
	CTB_CNT_DRE_PROCESSAMENTO.CD_CTR,
	CTB_CNT_DRE_PROCESSAMENTO.MES,
	CTB_CNT_DRE_PROCESSAMENTO.ANO,
	CTB_CNT_DRE_PROCESSAMENTO.TP_DRE,
	CTB_CNT_DRE_PROCESSAMENTO.TP_RAT_CENTRO_CUSTO,
	CTB_CNT_DRE_PROCESSAMENTO.CD_USU
FROM
	CTB_CNT_DRE_PROCESSAMENTO
WHERE
	DT_INI_PROCESSAMENTO IS NULL
ORDER BY
	ANO,
	MES

SET @CD_CTR_ATUAL=0

OPEN ProcDRE;
FETCH NEXT FROM ProcDRE INTO @CD_CTR,@MES,@ANO,@TP_DRE,@TP_RAT_CENTRO_CUSTO,@CD_USU;

WHILE @@FETCH_STATUS = 0
	BEGIN
		PRINT 'Mes.: ' + CONVERT(VARCHAR(5), @MES) + ' ano.: ' +  CONVERT(VARCHAR(5), @ANO) + ' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
		IF @CD_CTR_ATUAL>0
			BEGIN
				IF @CD_CTR_ATUAL <> @CD_CTR
				BEGIN
					UPDATE
						CTB_CNT_DRE_PROCESSAMENTO
					SET 
						DT_INI_PROCESSAMENTO=@DT_INI_PROC
					WHERE
						CD_CTR=@CD_CTR_ATUAL

					UPDATE
						CTB_CNT_DRE_PROCESSAMENTO
					SET 
						DT_FIM_PROCESSAMENTO=GETDATE()
					WHERE
						CD_CTR=@CD_CTR_ATUAL

					SET @DT_INI_PROC=GETDATE()
					SET @CD_CTR_ATUAL = @CD_CTR
				END
			END
		ELSE
			BEGIN
				SET @DT_INI_PROC=GETDATE()
				SET @CD_CTR_ATUAL = @CD_CTR
			END
		
		--Revisando movimento de vendas	
		EXECUTE P_CTB_CNT_DRE_CONSLD_VD_MES_EXECUTE_ALL @MES,@ANO;

		--Revisando movimento financeiro
		EXECUTE P_CTB_CNT_DRE_PROCESSAMENTO_MOV_FILIAL @MES,@ANO,@TP_DRE,@TP_RAT_CENTRO_CUSTO,@CD_USU;

		FETCH NEXT FROM ProcDRE INTO @CD_CTR,@MES,@ANO,@TP_DRE,@TP_RAT_CENTRO_CUSTO,@CD_USU;
	END;
CLOSE ProcDRE ;
DEALLOCATE ProcDRE;
UPDATE
	CTB_CNT_DRE_PROCESSAMENTO
SET 
	DT_FIM_PROCESSAMENTO=GETDATE()
WHERE
	CD_CTR=@CD_CTR_ATUAL
UPDATE
	CTB_CNT_DRE_PROCESSAMENTO
SET 
	DT_INI_PROCESSAMENTO=@DT_INI_PROC
WHERE
	CD_CTR=@CD_CTR_ATUAL

PRINT 'Concluido.';